/*
 * Created on Apr 20, 2005
 */
package edu.uoregon.tau.taujava.popup.actions;

import java.io.IOException;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class UninstrumentJava implements IObjectActionDelegate {


	/**
	 * Constructor for Action1.
	 */
	public UninstrumentJava() {
		super();
		return;
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	IStructuredSelection selection;

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		if (selection == null)
			return;
		try {
			/*
			 * Get the selected element, check and convert to the proper element
			 * type Transmit to the correct processing method.
			 */
			
			
			IJavaElement element = (IJavaElement) selection.getFirstElement();
			if (element.getElementType() == IJavaElement.JAVA_PROJECT) {
				IJavaProject jproject = (IJavaProject) element;
				uninstrumentProject(jproject);
			} else {
				if (element.getElementType() == IJavaElement.PACKAGE_FRAGMENT) {
					IPackageFragment jfragment = (IPackageFragment) element;
					uninstrumentPackage(jfragment);
				} else {
					if (element.getElementType() == IJavaElement.COMPILATION_UNIT) {
						ICompilationUnit jfile = (ICompilationUnit) element;
						uninstrumentJava(jfile);
					}
				}
			}

		} catch (JavaModelException e) {
			e.printStackTrace();
		} catch (MalformedTreeException e) {
			e.printStackTrace();
		} catch (BadLocationException e) {
			e.printStackTrace();
		} catch (ClassCastException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void uninstrumentProject(IJavaProject jproject)
			throws JavaModelException, MalformedTreeException, BadLocationException, IOException {
		/*
		 *  Run the package instrumenter on each package in the project
		 */

		IPackageFragment[] fragments = jproject.getPackageFragments();
		for (int i = 0; i < fragments.length; i++) {
			uninstrumentPackage(fragments[i]);
			fragments[i]=null;
		}
		fragments = null;

	}

	
	
	/*For each java file in the package that is not excluded (or is included) run the 
	 * java instrumenter*/
	public void uninstrumentPackage(IPackageFragment jfragment)
			throws JavaModelException, MalformedTreeException, BadLocationException {
		ICompilationUnit[] compunits = jfragment.getCompilationUnits();
		
	
		
		for (int i = 0; i < compunits.length; i++) {
			if(compunits[i]==null)break;
			uninstrumentJava(compunits[i]);
			compunits[i]=null;
		}
		compunits = null;
	}

	/*Obtain the java file, instrument each class it contains and resave the file*/
	public void uninstrumentJava(ICompilationUnit jfile) throws JavaModelException{
		//System.out.println("Entering main method!");
		ICompilationUnit workingjfile = jfile.getWorkingCopy(null);
		
		String source = workingjfile.getBuffer().getContents();//workingjfile.getSource();
		System.out.println(workingjfile.getElementName());
		int hit = 0;
		int dex = 0;
		int front = 0;
		int back = 0;
		String s1,s2;
		//System.out.println("Entering Loop!");
		while(true)
		{
			dex = 0;
			dex=source.indexOf("TAU_INSTRUMENTATION",dex);
			if(dex==-1)break;
			front=source.lastIndexOf("/*",dex);
			front = source.lastIndexOf('\n',front);
			dex = source.indexOf("TAU_INSTRUMENTATION",dex+1);
			back = source.indexOf("*/",dex);
			//back = source.indexOf('\n',back);
			back+=3;
			s1=source.substring(0,front);
			s2=source.substring(back);
			source=s1+s2;
			hit++;
			
		}
		s1=null;
		s2=null;
		if(hit==0){source = null; return;}
		
		//System.out.println("Still Going!");
		
		workingjfile.getBuffer().setContents(source);
		source = null;
		
		workingjfile.commitWorkingCopy(true,null);
		jfile.save(null,true);
		workingjfile = null;
		jfile=null;
		//System.out.println("Finished!");
		
	}

	
/*
	private boolean inLineCom(String input, int index){
		int lastret = input.lastIndexOf('\n',index);
		int lastcom = input.lastIndexOf("//",index);
		if(lastcom == -1)return false;
		return(lastret<lastcom);
	}*/
	
	//private boolean inBlockCom(String input, int index){
		//int lastend = input.lastIndexOf("*/",index);
	//	int lastcom = input.lastIndexOf("/*",index);
	//	if(lastcom == -1)return false;
	//	while(inLineCom(input,lastcom)){//System.out.println("BlockLoop: "+lastcom);
	//		lastcom = input.lastIndexOf("/*",lastcom-1);
	//		if(lastcom == -1)return false;
	//	}
		
	//	return(lastend<lastcom);
//	}
	/*
	private int indexSansComments(String input,String find, int startdex){
		int seeker = input.indexOf(find,startdex);
		if(seeker==-1)return seeker;
		while(inLineCom(input,seeker)||inBlockCom(input,seeker)){
			//System.out.println("SansLoop: "+seeker);
			seeker=input.indexOf(find,seeker+1);
			if(seeker==-1)return seeker;
		}
		return seeker;

	}
	
	private int lastIndexSansComments(String input,String find, int startdex){
		int seeker = input.lastIndexOf(find,startdex);
		if(seeker==-1)return seeker;
		while(inLineCom(input,seeker)||inBlockCom(input,seeker)){
			seeker=input.lastIndexOf(find,seeker);
			if(seeker==-1)return seeker;
		}
		return seeker;
	}*/
	

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection)
			this.selection = (IStructuredSelection) selection;
		else
			this.selection = null;
	}
}