#ifndef QRK_FIND_COM_PORTS_H
#define QRK_FIND_COM_PORTS_H

/*!
  \file
  \brief COM |[gꗗ̎擾

  \author Satofumi KAMIMURA

  $Id: FindComPorts.h 1811 2010-04-30 16:12:05Z satofumi $

  \attention mF Windows XP ̂݁Bł͖
*/

#include <string>
#include <vector>
#include <memory>


namespace qrk
{
    /*!
      \brief VA|[g̒Ts

      Windows ł́AWXg COM ꗗ擾ĕԂB\n
      Linux, MacOS ł́A^ꂽp^[Ɉvt@C擾ĕԂB
    */
    class FindComPorts
    {
    public:
        FindComPorts(void);
        ~FindComPorts(void);


        /*!
          \brief o^ς݂̃x[X̃NA
        */
        void clearBaseNames(void);


        /*!
          \brief Tŗp|[g̃x[Xǉ

          \param[in] base_name |[g̃x[X
        */
        void addBaseName(const char* base_name);


        /*!
          \brief o^ς݂̃|[g̃x[XԂ

          Linux ŗp

          \return |[g̃x[X
        */
        std::vector<std::string> baseNames(void);


        void addDriverName(const char* driver_name);


        /*!
          \brief COM |[gꗗ̎擾

          \param[out] ports o|[g
          \param[in] all_ports addDriverName() Ŏw肵|[ĝݎ擾Ƃ false

          \retval COM ꗗi[ꂽ string z
        */
        size_t find(std::vector<std::string>& ports, bool all_ports = true);

        size_t find(std::vector<std::string>& ports,
                    std::vector<std::string>& driver_names, bool all_ports = true);

    private:
        FindComPorts(const FindComPorts& rhs);
        FindComPorts& operator = (const FindComPorts& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_FIND_COM_PORTS_H */
