<?xml-stylesheet href="http://www.w3.org/StyleSheets/base.css" type="text/css"?><?xml-stylesheet href="http://www.w3.org/2002/02/style-xsl.css" type="text/css"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:h="http://www.w3.org/1999/xhtml"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:foaf="http://xmlns.com/foaf/0.1/"
  exclude-result-prefixes="h">

<!-- Output method XML -->
<xsl:output method="xml"
  indent="yes"
  omit-xml-declaration="no"
  encoding="utf-8"  />


<!-- Documenting the XSLT : fill the @@@-->
  <xsl:template match="/">
    <rdf:RDF>
      <xsl:apply-templates />
    </rdf:RDF>
  </xsl:template>

  <xsl:template match="h:address/h:a[@rel='page']">

    <!-- using rel=alternate for the subject is a bit of a kludge -->
    <xsl:variable name="subject"
	select='/h:html/h:head/h:link[@rel="alternate"]/@href' />
    <rdf:Description rdf:about="{$subject}">
      <foaf:maker>
	<foaf:Agent>
	  <foaf:isPrimaryTopicOf rdf:resource="{@href}"/>
	</foaf:Agent>
      </foaf:maker>
    </rdf:Description>
  </xsl:template>

  <xsl:template match="h:address/h:a[@rel='maker']">
    <!-- using rel=alternate for the subject is a bit of a kludge -->
    <xsl:variable name="subject"
	select='/h:html/h:head/h:link[@rel="alternate"]/@href' />
    <rdf:Description rdf:about="{$subject}">
      <foaf:maker>
	<foaf:Agent rdf:about="{@href}">
	  <foaf:name><xsl:value-of select="normalize-space(.)"/></foaf:name>
	</foaf:Agent>
      </foaf:maker>
    </rdf:Description>
  </xsl:template>

  <!-- don't pass text thru -->
  <xsl:template match="text()|@*">
  </xsl:template>


</xsl:stylesheet>
