/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export.compressors;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import org.web3d.vrml.export.compressors.BitPacker;
import org.web3d.vrml.export.compressors.HuffmanNode;

class IntegerHuffmanNode
extends HuffmanNode {
    int data;
    int dataLength;
    static DataComparator dataComparator = new DataComparator();

    protected IntegerHuffmanNode() {
    }

    protected IntegerHuffmanNode(int n) {
        this.data = n;
    }

    public void setValue(int n) {
        this.data = n;
    }

    public int getValue() {
        return this.data;
    }

    public void writeData(BitPacker bitPacker, int n) throws IOException {
        bitPacker.pack(this.data, n);
    }

    void collectLeaves(int n, int n2, Collection collection) {
        this.tag = n;
        this.tagLength = n2;
        collection.add(this);
    }

    public String toString() {
        return "data: " + this.data + "\ntag 0x" + Integer.toBinaryString(this.tag) + " tag length " + this.tagLength + "\nfrequency: " + this.frequency;
    }

    public int hashCode() {
        return this.data;
    }

    public boolean equals(Object object) {
        if (object instanceof IntegerHuffmanNode) {
            return this.data == ((IntegerHuffmanNode)object).getValue();
        }
        return false;
    }

    static class DataComparator
    implements Comparator {
        DataComparator() {
        }

        public final int compare(Object object, Object object2) {
            return ((IntegerHuffmanNode)object).data - ((IntegerHuffmanNode)object2).data;
        }
    }
}

