/*
 * huffman_tables.h
 * Copyright (C) 2004 Gildas Bazin <gbazin@videolan.org>
 *
 * This file is part of libdca, a free DTS Coherent Acoustics stream decoder.
 * See http://www.videolan.org/developers/libdca.html for updates.
 *
 * libdca is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libdca is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

typedef struct huff_entry_s
{
    int length;
    int code;
    int value;

} huff_entry_t;

huff_entry_t bitalloc_a_12[] =
{
  { 1,     0,  1}, { 2,     2,  2}, { 3,     6,  3}, { 4,    14,  4}, 
  { 5,    30,  5}, { 6,    62,  6}, { 8,   255,  7}, { 8,   254,  8}, 
  { 9,   507,  9}, { 9,   506, 10}, { 9,   505, 11}, { 9,   504, 12}, 
  { 0,     0,  0}
};

huff_entry_t bitalloc_b_12[] =
{
  { 1,     1,  1}, { 2,     0,  2}, { 3,     2,  3}, { 5,    15,  4}, 
  { 5,    12,  5}, { 6,    29,  6}, { 7,    57,  7}, { 7,    56,  8}, 
  { 7,    55,  9}, { 7,    54, 10}, { 7,    53, 11}, { 7,    52, 12}, 
  { 0,     0,  0}  
};

huff_entry_t bitalloc_c_12[] =
{
  { 2,     0,  1}, { 3,     7,  2}, { 3,     5,  3}, { 3,     4,  4}, 
  { 3,     2,  5}, { 4,    13,  6}, { 4,    12,  7}, { 4,     6,  8}, 
  { 5,    15,  9}, { 6,    29, 10}, { 7,    57, 11}, { 7,    56, 12}, 
  { 0,     0,  0}
};

huff_entry_t bitalloc_d_12[] =
{
  { 2,     3,  1}, { 2,     2,  2}, { 2,     0,  3}, { 3,     2,  4}, 
  { 4,     6,  5}, { 5,    14,  6}, { 6,    30,  7}, { 7,    62,  8}, 
  { 8,   126,  9}, { 9,   254, 10}, {10,   511, 11}, {10,   510, 12}, 
  { 0,     0,  0}
};

huff_entry_t bitalloc_e_12[] =
{
  { 1,     1,  1}, { 2,     0,  2}, { 3,     2,  3}, { 4,     6,  4}, 
  { 5,    14,  5}, { 7,    63,  6}, { 7,    61,  7}, { 8,   124,  8}, 
  { 8,   121,  9}, { 8,   120, 10}, { 9,   251, 11}, { 9,   250, 12}, 
  { 0,     0,  0}
};

huff_entry_t *bitalloc_12[] =
{
  bitalloc_a_12,
  bitalloc_b_12,
  bitalloc_c_12,
  bitalloc_d_12,
  bitalloc_e_12
};

huff_entry_t scales_a_129[] =
{
  { 2,     1,  0}, { 3,     6,  1}, { 3,     5, -1}, { 3,     0,  2}, 
  { 4,    15, -2}, { 4,     8,  3}, { 4,     3, -3}, { 5,    28,  4}, 
  { 5,    19, -4}, { 5,     4,  5}, { 6,    59, -5}, { 6,    36,  6}, 
  { 6,    11, -6}, { 7,    75,  7}, { 7,    74, -7}, { 8,   233,  8}, 
  { 8,   232, -8}, { 8,    41,  9}, { 8,    40, -9}, { 9,    87, 10}, 
  { 9,    86,-10}, {10,   937, 11}, {10,   936,-11}, {11,  1877, 12}, 
  {11,  1876,-12}, {11,   341, 13}, {11,   340,-13}, {12,   686, 14}, 
  {12,   685,-14}, {13,  1375, 15}, {13,  1374,-15}, {13,  1369, 16}, 
  {13,  1368,-16}, {13,  1359, 17}, {13,  1358,-17}, {13,  1357, 18}, 
  {13,  1356,-18}, {13,  1355, 19}, {13,  1354,-19}, {13,  1353, 20}, 
  {13,  1352,-20}, {13,  1351, 21}, {13,  1350,-21}, {13,  1349, 22}, 
  {13,  1348,-22}, {13,  1347, 23}, {13,  1346,-23}, {13,  1345, 24}, 
  {13,  1344,-24}, {14, 15103, 25}, {14, 15102,-25}, {14, 15101, 26}, 
  {14, 15100,-26}, {14, 15099, 27}, {14, 15098,-27}, {14, 15097, 28}, 
  {14, 15096,-28}, {14, 15095, 29}, {14, 15094,-29}, {14, 15093, 30}, 
  {14, 15092,-30}, {14, 15091, 31}, {14, 15090,-31}, {14, 15089, 32}, 
  {14, 15088,-32}, {14, 15087, 33}, {14, 15086,-33}, {14, 15085, 34}, 
  {14, 15084,-34}, {14, 15083, 35}, {14, 15082,-35}, {14, 15081, 36}, 
  {14, 15080,-36}, {14, 15079, 37}, {14, 15078,-37}, {14, 15077, 38}, 
  {14, 15076,-38}, {14, 15075, 39}, {14, 15074,-39}, {14, 15073, 40}, 
  {14, 15072,-40}, {14, 15071, 41}, {14, 15070,-41}, {14, 15069, 42}, 
  {14, 15068,-42}, {14, 15067, 43}, {14, 15066,-43}, {14, 15065, 44}, 
  {14, 15064,-44}, {14, 15063, 45}, {14, 15062,-45}, {14, 15061, 46}, 
  {14, 15060,-46}, {14, 15059, 47}, {14, 15058,-47}, {14, 15057, 48}, 
  {14, 15056,-48}, {14, 15055, 49}, {14, 15054,-49}, {14, 15053, 50}, 
  {14, 15052,-50}, {14, 15051, 51}, {14, 15050,-51}, {14, 15049, 52}, 
  {14, 15048,-52}, {14, 15047, 53}, {14, 15046,-53}, {14, 15045, 54}, 
  {14, 15044,-54}, {14, 15043, 55}, {14, 15042,-55}, {14, 15041, 56}, 
  {14, 15040,-56}, {14, 15039, 57}, {14, 15038,-57}, {14, 15037, 58}, 
  {14, 15036,-58}, {14, 15035, 59}, {14, 15034,-59}, {14, 15033, 60}, 
  {14, 15032,-60}, {14, 15031, 61}, {14, 15030,-61}, {14, 15029, 62}, 
  {14, 15028,-62}, {14, 15027, 63}, {14, 15026,-63}, {14, 15025, 64}, 
  {14, 15024,-64}, { 0,     0,  0}
};

huff_entry_t scales_b_129[] =
{
  { 3,     3,  0}, { 3,     2,  1}, { 3,     1, -1}, { 4,    15,  2}, 
  { 4,    14, -2}, { 4,    12,  3}, { 4,    11, -3}, { 4,    10,  4}, 
  { 4,     9, -4}, { 4,     0,  5}, { 5,    27, -5}, { 5,    17,  6}, 
  { 5,    16, -6}, { 6,    53,  7}, { 6,    52, -7}, { 6,     5,  8}, 
  { 6,     4, -8}, { 7,    13,  9}, { 7,    12, -9}, { 8,    29, 10}, 
  { 8,    28,-10}, { 9,    60, 11}, {10,   127,-11}, {11,   253, 12}, 
  {11,   252,-12}, {12,   491, 13}, {12,   490,-13}, {13,   979, 14}, 
  {13,   978,-14}, {14,  1955, 15}, {14,  1954,-15}, {14,  1953, 16}, 
  {14,  1952,-16}, {15,  4031, 17}, {15,  4030,-17}, {15,  4029, 18}, 
  {15,  4028,-18}, {15,  4027, 19}, {15,  4026,-19}, {15,  4025, 20}, 
  {15,  4024,-20}, {15,  4023, 21}, {15,  4022,-21}, {15,  4021, 22}, 
  {15,  4020,-22}, {15,  4019, 23}, {15,  4018,-23}, {15,  4017, 24}, 
  {15,  4016,-24}, {15,  4015, 25}, {15,  4014,-25}, {15,  4013, 26}, 
  {15,  4012,-26}, {15,  4011, 27}, {15,  4010,-27}, {15,  4009, 28}, 
  {15,  4008,-28}, {15,  4007, 29}, {15,  4006,-29}, {15,  4005, 30}, 
  {15,  4004,-30}, {15,  4003, 31}, {15,  4002,-31}, {15,  4001, 32}, 
  {15,  4000,-32}, {15,  3999, 33}, {15,  3998,-33}, {15,  3997, 34}, 
  {15,  3996,-34}, {15,  3995, 35}, {15,  3994,-35}, {15,  3993, 36}, 
  {15,  3992,-36}, {15,  3991, 37}, {15,  3990,-37}, {15,  3989, 38}, 
  {15,  3988,-38}, {15,  3987, 39}, {15,  3986,-39}, {15,  3985, 40}, 
  {15,  3984,-40}, {15,  3983, 41}, {15,  3982,-41}, {15,  3981, 42}, 
  {15,  3980,-42}, {15,  3979, 43}, {15,  3978,-43}, {15,  3977, 44}, 
  {15,  3976,-44}, {15,  3975, 45}, {15,  3974,-45}, {15,  3973, 46}, 
  {15,  3972,-46}, {15,  3971, 47}, {15,  3970,-47}, {15,  3969, 48}, 
  {15,  3968,-48}, {15,  3967, 49}, {15,  3966,-49}, {15,  3965, 50}, 
  {15,  3964,-50}, {15,  3963, 51}, {15,  3962,-51}, {15,  3961, 52}, 
  {15,  3960,-52}, {15,  3959, 53}, {15,  3958,-53}, {15,  3957, 54}, 
  {15,  3956,-54}, {15,  3955, 55}, {15,  3954,-55}, {15,  3953, 56}, 
  {15,  3952,-56}, {15,  3951, 57}, {15,  3950,-57}, {15,  3949, 58}, 
  {15,  3948,-58}, {15,  3947, 59}, {15,  3946,-59}, {15,  3945, 60}, 
  {15,  3944,-60}, {15,  3943, 61}, {15,  3942,-61}, {15,  3941, 62}, 
  {15,  3940,-62}, {15,  3939, 63}, {15,  3938,-63}, {15,  3937, 64}, 
  {15,  3936,-64}, { 0,     0,  0}
};

huff_entry_t scales_c_129[] =
{
  { 3,     4,  0}, { 3,     1,  1}, { 3,     0, -1}, { 4,    13,  2}, 
  { 4,    12, -2}, { 4,     7,  3}, { 4,     6, -3}, { 5,    31,  4}, 
  { 5,    30, -4}, { 5,    23,  5}, { 5,    22, -5}, { 5,    11,  6}, 
  { 5,    10, -6}, { 6,    59,  7}, { 6,    58, -7}, { 6,    43,  8}, 
  { 6,    42, -8}, { 6,    19,  9}, { 6,    18, -9}, { 7,   115, 10}, 
  { 7,   114,-10}, { 7,    83, 11}, { 7,    82,-11}, { 7,    35, 12}, 
  { 7,    34,-12}, { 8,   227, 13}, { 8,   226,-13}, { 8,   162, 14}, 
  { 8,   161,-14}, { 8,    66, 15}, { 8,    65,-15}, { 9,   450, 16}, 
  { 9,   449,-16}, { 9,   321, 17}, { 9,   320,-17}, { 9,   129, 18}, 
  { 9,   128,-18}, {10,   897, 19}, {10,   896,-19}, {10,   652, 20}, 
  {10,   271,-20}, {10,   268, 21}, {11,  1807,-21}, {11,  1308, 22}, 
  {11,  1307,-22}, {11,   540, 23}, {11,   539,-23}, {12,  3612, 24}, 
  {12,  3611,-24}, {12,  2613, 25}, {12,  2612,-25}, {12,  1077, 26}, 
  {12,  1076,-26}, {13,  7226, 27}, {13,  7221,-27}, {13,  2167, 28}, 
  {13,  2166,-28}, {13,  2164, 29}, {14, 14455,-29}, {14, 14441, 30}, 
  {14, 14440,-30}, {14,  4331, 31}, {14,  4330,-31}, {15, 28909, 32}, 
  {15, 28908,-32}, {15, 28879, 33}, {15, 28878,-33}, {15, 28877, 34}, 
  {15, 28876,-34}, {15, 28875, 35}, {15, 28874,-35}, {15, 28873, 36}, 
  {15, 28872,-36}, {15, 28871, 37}, {15, 28870,-37}, {15, 28869, 38}, 
  {15, 28868,-38}, {15, 28867, 39}, {15, 28866,-39}, {15, 28865, 40}, 
  {15, 28864,-40}, {15, 20991, 41}, {15, 20990,-41}, {15, 20989, 42}, 
  {15, 20988,-42}, {15, 20987, 43}, {15, 20986,-43}, {15, 20985, 44}, 
  {15, 20984,-44}, {15, 20983, 45}, {15, 20982,-45}, {15, 20981, 46}, 
  {15, 20980,-46}, {15, 20979, 47}, {15, 20978,-47}, {15, 20977, 48}, 
  {15, 20976,-48}, {15, 20975, 49}, {15, 20974,-49}, {15, 20973, 50}, 
  {15, 20972,-50}, {15, 20971, 51}, {15, 20970,-51}, {15, 20969, 52}, 
  {15, 20968,-52}, {15, 20967, 53}, {15, 20966,-53}, {15, 20965, 54}, 
  {15, 20964,-54}, {15, 20963, 55}, {15, 20962,-55}, {15, 20961, 56}, 
  {15, 20960,-56}, {15, 20959, 57}, {15, 20958,-57}, {15, 20957, 58}, 
  {15, 20956,-58}, {15, 20955, 59}, {15, 20954,-59}, {15, 20953, 60}, 
  {15, 20952,-60}, {15, 20951, 61}, {15, 20950,-61}, {15, 20949, 62}, 
  {15, 20948,-62}, {15, 20947, 63}, {15, 20946,-63}, {15, 20945, 64}, 
  {15, 20944,-64}, { 0,     0,  0}
};

huff_entry_t scales_d_129[] =
{
  { 2,     0,  0}, { 3,     5,  1}, { 3,     4, -1}, { 4,    15,  2}, 
  { 4,    14, -2}, { 4,     7,  3}, { 4,     6, -3}, { 5,    26,  4}, 
  { 5,    25, -4}, { 5,    10,  5}, { 5,     9, -5}, { 6,    54,  6}, 
  { 6,    49, -6}, { 6,    22,  7}, { 6,    17, -7}, { 7,   110,  8}, 
  { 7,    97, -8}, { 7,    46,  9}, { 7,    33, -9}, { 8,   193, 10}, 
  { 8,   192,-10}, { 8,    65, 11}, { 8,    64,-11}, { 9,   444, 12}, 
  { 9,   191,-12}, { 9,   188, 13}, {10,   895,-13}, {10,   890, 14}, 
  {10,   381,-14}, {10,   378, 15}, {11,  1789,-15}, {11,   761, 16}, 
  {11,   760,-16}, {12,  3577, 17}, {12,  3576,-17}, {12,  1519, 18}, 
  {12,  1518,-18}, {12,  1516, 19}, {13,  7151,-19}, {13,  7128, 20}, 
  {13,  3035,-20}, {14, 14301, 21}, {14, 14300,-21}, {14,  6069, 22}, 
  {14,  6068,-22}, {15, 28599, 23}, {15, 28598,-23}, {15, 28597, 24}, 
  {15, 28596,-24}, {15, 28595, 25}, {15, 28594,-25}, {15, 28593, 26}, 
  {15, 28592,-26}, {15, 28591, 27}, {15, 28590,-27}, {15, 28589, 28}, 
  {15, 28588,-28}, {15, 28587, 29}, {15, 28586,-29}, {15, 28585, 30}, 
  {15, 28584,-30}, {15, 28583, 31}, {15, 28582,-31}, {15, 28581, 32}, 
  {15, 28580,-32}, {15, 28579, 33}, {15, 28578,-33}, {15, 28577, 34}, 
  {15, 28576,-34}, {15, 28575, 35}, {15, 28574,-35}, {15, 28573, 36}, 
  {15, 28572,-36}, {15, 28571, 37}, {15, 28570,-37}, {15, 28569, 38}, 
  {15, 28568,-38}, {15, 28567, 39}, {15, 28566,-39}, {15, 28565, 40}, 
  {15, 28564,-40}, {15, 28563, 41}, {15, 28562,-41}, {15, 28561, 42}, 
  {15, 28560,-42}, {15, 28559, 43}, {15, 28558,-43}, {15, 28557, 44}, 
  {15, 28556,-44}, {15, 28555, 45}, {15, 28554,-45}, {15, 28553, 46}, 
  {15, 28552,-46}, {15, 28551, 47}, {15, 28550,-47}, {15, 28549, 48}, 
  {15, 28548,-48}, {15, 28547, 49}, {15, 28546,-49}, {15, 28545, 50}, 
  {15, 28544,-50}, {15, 28543, 51}, {15, 28542,-51}, {15, 28541, 52}, 
  {15, 28540,-52}, {15, 28539, 53}, {15, 28538,-53}, {15, 28537, 54}, 
  {15, 28536,-54}, {15, 28535, 55}, {15, 28534,-55}, {15, 28533, 56}, 
  {15, 28532,-56}, {15, 28531, 57}, {15, 28530,-57}, {15, 28529, 58}, 
  {15, 28528,-58}, {15, 28527, 59}, {15, 28526,-59}, {15, 28525, 60}, 
  {15, 28524,-60}, {15, 28523, 61}, {15, 28522,-61}, {15, 28521, 62}, 
  {15, 28520,-62}, {15, 28519, 63}, {15, 28518,-63}, {15, 28517, 64}, 
  {15, 28516,-64}, { 0,     0,  0}
};

huff_entry_t scales_e_129[] =
{
  { 4,    14,  0}, { 4,    11,  1}, { 4,    10, -1}, { 4,     7,  2}, 
  { 4,     6, -2}, { 4,     3,  3}, { 4,     2, -3}, { 5,    31,  4}, 
  { 5,    30, -4}, { 5,    25,  5}, { 5,    24, -5}, { 5,    17,  6}, 
  { 5,    16, -6}, { 5,     9,  7}, { 5,     8, -7}, { 5,     1,  8}, 
  { 5,     0, -8}, { 6,    53,  9}, { 6,    52, -9}, { 6,    37, 10}, 
  { 6,    36,-10}, { 6,    21, 11}, { 6,    20,-11}, { 6,     5, 12}, 
  { 6,     4,-12}, { 7,   109, 13}, { 7,   108,-13}, { 7,    77, 14}, 
  { 7,    76,-14}, { 7,    45, 15}, { 7,    44,-15}, { 7,    13, 16}, 
  { 7,    12,-16}, { 8,   221, 17}, { 8,   220,-17}, { 8,   157, 18}, 
  { 8,   156,-18}, { 8,    93, 19}, { 8,    92,-19}, { 8,    29, 20}, 
  { 8,    28,-20}, { 9,   445, 21}, { 9,   444,-21}, { 9,   317, 22}, 
  { 9,   316,-22}, { 9,   189, 23}, { 9,   188,-23}, { 9,    61, 24}, 
  { 9,    60,-24}, {10,   892, 25}, {10,   639,-25}, {10,   637, 26}, 
  {10,   636,-26}, {10,   381, 27}, {10,   380,-27}, {10,   125, 28}, 
  {10,   124,-28}, {11,  1788, 29}, {11,  1787,-29}, {11,  1276, 30}, 
  {11,   767,-30}, {11,   764, 31}, {11,   255,-31}, {11,   252, 32}, 
  {12,  3583,-32}, {12,  3579, 33}, {12,  3578,-33}, {12,  2555, 34}, 
  {12,  2554,-34}, {12,  1531, 35}, {12,  1530,-35}, {12,   507, 36}, 
  {12,   506,-36}, {13,  7160, 37}, {13,  7147,-37}, {13,  7144, 38}, 
  {13,  3067,-38}, {13,  3065, 39}, {13,  3064,-39}, {13,  1017, 40}, 
  {13,  1016,-40}, {14, 14330, 41}, {14, 14329,-41}, {14, 14291, 42}, 
  {14, 14290,-42}, {14,  6132, 43}, {14,  2039,-43}, {14,  2038, 44}, 
  {14,  2037,-44}, {15, 28663, 45}, {15, 28662,-45}, {15, 28585, 46}, 
  {15, 28584,-46}, {15, 12267, 47}, {15, 12266,-47}, {15,  4073, 48}, 
  {15,  4072,-48}, {16, 57315, 49}, {16, 57314,-49}, {16, 57313, 50}, 
  {16, 57312,-50}, {16, 57311, 51}, {16, 57310,-51}, {16, 57309, 52}, 
  {16, 57308,-52}, {16, 57307, 53}, {16, 57306,-53}, {16, 57305, 54}, 
  {16, 57304,-54}, {16, 57303, 55}, {16, 57302,-55}, {16, 57301, 56}, 
  {16, 57300,-56}, {16, 57299, 57}, {16, 57298,-57}, {16, 57297, 58}, 
  {16, 57296,-58}, {16, 57295, 59}, {16, 57294,-59}, {16, 57293, 60}, 
  {16, 57292,-60}, {16, 57291, 61}, {16, 57290,-61}, {16, 57289, 62}, 
  {16, 57288,-62}, {16, 57175, 63}, {16, 57174,-63}, {16, 57173, 64}, 
  {16, 57172,-64}, { 0,     0,  0}
};

huff_entry_t *scales_129[] =
{
  scales_a_129,
  scales_b_129,
  scales_c_129,
  scales_d_129,
  scales_e_129
};

huff_entry_t bitalloc_a_3[] =
{
  { 1,     0,  0}, { 2,     2,  1}, { 2,     3, -1}, { 0,     0,  0}
};

huff_entry_t bitalloc_a_4[] =
{
  { 1,     0,  0}, { 2,     2,  1}, { 3,     6,  2}, { 3,     7,  3}, 
  { 0,     0,  0}
};

huff_entry_t bitalloc_b_4[] =
{
  { 2,     2,  0}, { 3,     6,  1}, { 3,     7,  2}, { 1,     0,  3}, 
  { 0,     0,  0}
};

huff_entry_t bitalloc_c_4[] =
{
  { 3,     6,  0}, { 3,     7,  1}, { 1,     0,  2}, { 2,     2,  3}, 
  { 0,     0,  0}
};

huff_entry_t bitalloc_d_4[] =
{
  { 2,     0,  0}, { 2,     1,  1}, { 2,     2,  2}, { 2,     3,  3}, 
  { 0,     0,  0}
};

huff_entry_t *tmode[] =
{
  bitalloc_a_4,
  bitalloc_b_4,
  bitalloc_c_4,
  bitalloc_d_4
};

huff_entry_t bitalloc_a_5[] =
{
  { 1,     0,  0}, { 2,     2,  1}, { 3,     6, -1}, { 4,    14,  2}, 
  { 4,    15, -2}, { 0,     0,  0}
};

huff_entry_t bitalloc_b_5[] =
{
  { 2,     2,  0}, { 2,     0,  1}, { 2,     1, -1}, { 3,     6,  2}, 
  { 3,     7, -2}, { 0,     0,  0}
};

huff_entry_t bitalloc_c_5[] =
{
  { 1,     0,  0}, { 3,     4,  1}, { 3,     5, -1}, { 3,     6,  2}, 
  { 3,     7, -2}, { 0,     0,  0}
};

huff_entry_t bitalloc_a_7[] =
{
  { 1,     0,  0}, { 3,     6,  1}, { 3,     5, -1}, { 3,     4,  2}, 
  { 4,    14, -2}, { 5,    31,  3}, { 5,    30, -3}, { 0,     0,  0}
};

huff_entry_t bitalloc_b_7[] =
{
  { 2,     3,  0}, { 2,     1,  1}, { 2,     0, -1}, { 3,     4,  2}, 
  { 4,    11, -2}, { 5,    21,  3}, { 5,    20, -3}, { 0,     0,  0}
};

huff_entry_t bitalloc_c_7[] =
{
  { 2,     3,  0}, { 2,     2,  1}, { 2,     1, -1}, { 4,     3,  2}, 
  { 4,     2, -2}, { 4,     1,  3}, { 4,     0, -3}, { 0,     0,  0}
};

huff_entry_t bitalloc_a_9[] =
{
  { 1,     0,  0}, { 3,     7,  1}, { 3,     5, -1}, { 4,    13,  2}, 
  { 4,     9, -2}, { 4,     8,  3}, { 5,    25, -3}, { 6,    49,  4}, 
  { 6,    48, -4}, { 0,     0,  0}
};

huff_entry_t bitalloc_b_9[] =
{
  { 2,     2,  0}, { 2,     0,  1}, { 3,     7, -1}, { 3,     3,  2}, 
  { 3,     2, -2}, { 5,    27,  3}, { 5,    26, -3}, { 5,    25,  4}, 
  { 5,    24, -4}, { 0,     0,  0}
};

huff_entry_t bitalloc_c_9[] =
{
  { 2,     2,  0}, { 2,     0,  1}, { 3,     7, -1}, { 3,     6,  2}, 
  { 3,     2, -2}, { 4,     6,  3}, { 5,    15, -3}, { 6,    29,  4}, 
  { 6,    28, -4}, { 0,     0,  0}
};

huff_entry_t bitalloc_a_13[] =
{
  { 1,     0,  0}, { 3,     4,  1}, { 4,    15, -1}, { 4,    13,  2}, 
  { 4,    12, -2}, { 4,    10,  3}, { 5,    29, -3}, { 5,    22,  4}, 
  { 6,    57, -4}, { 6,    47,  5}, { 6,    46, -5}, { 7,   113,  6}, 
  { 7,   112, -6}, { 0,     0,  0}
};

huff_entry_t bitalloc_b_13[] =
{
  { 2,     0,  0}, { 3,     6,  1}, { 3,     5, -1}, { 3,     2,  2}, 
  { 4,    15, -2}, { 4,     9,  3}, { 4,     7, -3}, { 4,     6,  4}, 
  { 5,    29, -4}, { 5,    17,  5}, { 5,    16, -5}, { 6,    57,  6}, 
  { 6,    56, -6}, { 0,     0,  0}
};

huff_entry_t bitalloc_c_13[] =
{
  { 3,     5,  0}, { 3,     4,  1}, { 3,     3, -1}, { 3,     2,  2}, 
  { 3,     0, -2}, { 4,    15,  3}, { 4,    14, -3}, { 4,    12,  4}, 
  { 4,     3, -4}, { 5,    27,  5}, { 5,    26, -5}, { 5,     5,  6}, 
  { 5,     4, -6}, { 0,     0,  0}
};

huff_entry_t bitalloc_a_17[] =
{
  { 2,     1,  0}, { 3,     7,  1}, { 3,     6, -1}, { 3,     4,  2}, 
  { 3,     1, -2}, { 4,    11,  3}, { 4,    10, -3}, { 4,     0,  4}, 
  { 5,     3, -4}, { 6,     4,  5}, { 7,    11, -5}, { 8,    20,  6}, 
  { 9,    43, -6}, {10,    84,  7}, {11,   171, -7}, {12,   341,  8}, 
  {12,   340, -8}, { 0,     0,  0}
};

huff_entry_t bitalloc_b_17[] =
{
  { 2,     0,  0}, { 3,     6,  1}, { 3,     5, -1}, { 3,     2,  2}, 
  { 4,    15, -2}, { 4,     9,  3}, { 4,     8, -3}, { 5,    29,  4}, 
  { 5,    28, -4}, { 5,    14,  5}, { 5,    13, -5}, { 6,    30,  6}, 
  { 6,    25, -6}, { 6,    24,  7}, { 7,    63, -7}, { 8,   125,  8}, 
  { 8,   124, -8}, { 0,     0,  0}
};

huff_entry_t bitalloc_c_17[] =
{
  { 3,     6,  0}, { 3,     4,  1}, { 3,     3, -1}, { 3,     0,  2}, 
  { 4,    15, -2}, { 4,    11,  3}, { 4,    10, -3}, { 4,     4,  4}, 
  { 4,     3, -4}, { 5,    29,  5}, { 5,    28, -5}, { 5,    10,  6}, 
  { 5,     5, -6}, { 5,     4,  7}, { 6,    23, -7}, { 7,    45,  8}, 
  { 7,    44, -8}, { 0,     0,  0}
};

huff_entry_t bitalloc_d_17[] =
{
  { 1,     0,  0}, { 3,     7,  1}, { 3,     6, -1}, { 4,    11,  2}, 
  { 4,    10, -2}, { 5,    19,  3}, { 5,    18, -3}, { 6,    35,  4}, 
  { 6,    34, -4}, { 7,    67,  5}, { 7,    66, -5}, { 8,   131,  6}, 
  { 8,   130, -6}, { 9,   259,  7}, { 9,   258, -7}, { 9,   257,  8}, 
  { 9,   256, -8}, { 0,     0,  0}
};

huff_entry_t bitalloc_e_17[] =
{
  { 1,     0,  0}, { 3,     5,  1}, { 3,     4, -1}, { 4,    12,  2}, 
  { 5,    31, -2}, { 5,    28,  3}, { 5,    27, -3}, { 6,    60,  4}, 
  { 6,    59, -4}, { 6,    53,  5}, { 6,    52, -5}, { 7,   122,  6}, 
  { 7,   117, -6}, { 8,   247,  7}, { 8,   246, -7}, { 8,   233,  8}, 
  { 8,   232, -8}, { 0,     0,  0}
};

huff_entry_t bitalloc_f_17[] =
{
  { 3,     6,  0}, { 3,     5,  1}, { 3,     4, -1}, { 3,     2,  2}, 
  { 3,     1, -2}, { 4,    15,  3}, { 4,    14, -3}, { 4,     6,  4}, 
  { 4,     1, -4}, { 5,    14,  5}, { 5,     1, -5}, { 6,    31,  6}, 
  { 6,    30, -6}, { 6,     0,  7}, { 7,     3, -7}, { 8,     5,  8}, 
  { 8,     4, -8}, { 0,     0,  0}
};

huff_entry_t bitalloc_g_17[] =
{
  { 2,     2,  0}, { 3,     7,  1}, { 3,     6, -1}, { 3,     1,  2}, 
  { 3,     0, -2}, { 4,     5,  3}, { 4,     4, -3}, { 5,    14,  4}, 
  { 5,    13, -4}, { 6,    30,  5}, { 6,    25, -5}, { 7,    62,  6}, 
  { 7,    49, -6}, { 8,   127,  7}, { 8,   126, -7}, { 8,    97,  8}, 
  { 8,    96, -8}, { 0,     0,  0}
};

huff_entry_t bitalloc_a_25[] =
{
  { 3,     6,  0}, { 3,     4,  1}, { 3,     3, -1}, { 3,     1,  2}, 
  { 3,     0, -2}, { 4,    15,  3}, { 4,    14, -3}, { 4,     5,  4}, 
  { 4,     4, -4}, { 5,    22,  5}, { 5,    21, -5}, { 6,    47,  6}, 
  { 6,    46, -6}, { 7,    83,  7}, { 7,    82, -7}, { 8,   163,  8}, 
  { 8,   162, -8}, { 8,   160,  9}, { 9,   323, -9}, {10,   644, 10}, 
  {11,  1291,-10}, {12,  2580, 11}, {13,  5163,-11}, {14, 10325, 12}, 
  {14, 10324,-12}, { 0,     0,  0}
};

huff_entry_t bitalloc_b_25[] =
{
  { 3,     5,  0}, { 3,     2,  1}, { 3,     1, -1}, { 4,    15,  2}, 
  { 4,    14, -2}, { 4,     9,  3}, { 4,     8, -3}, { 4,     6,  4}, 
  { 4,     1, -4}, { 5,    26,  5}, { 5,    25, -5}, { 5,    15,  6}, 
  { 5,    14, -6}, { 6,    55,  7}, { 6,    54, -7}, { 6,    49,  8}, 
  { 6,    48, -8}, { 6,     1,  9}, { 6,     0, -9}, { 7,     6, 10}, 
  { 7,     5,-10}, { 7,     4, 11}, { 8,    15,-11}, { 9,    29, 12}, 
  { 9,    28,-12}, { 0,     0,  0}
};

huff_entry_t bitalloc_c_25[] =
{
  { 3,     1,  0}, { 4,    15,  1}, { 4,    14, -1}, { 4,    12,  2}, 
  { 4,    11, -2}, { 4,     9,  3}, { 4,     8, -3}, { 4,     6,  4}, 
  { 4,     5, -4}, { 4,     1,  5}, { 4,     0, -5}, { 5,    26,  6}, 
  { 5,    21, -6}, { 5,    15,  7}, { 5,    14, -7}, { 5,     8,  8}, 
  { 6,    55, -8}, { 6,    41,  9}, { 6,    40, -9}, { 6,    18, 10}, 
  { 7,   109,-10}, { 7,   108, 11}, { 7,    39,-11}, { 8,    77, 12}, 
  { 8,    76,-12}, { 0,     0,  0}
};

huff_entry_t bitalloc_d_25[] =
{
  { 2,     2,  0}, { 3,     7,  1}, { 3,     6, -1}, { 3,     1,  2}, 
  { 3,     0, -2}, { 4,     5,  3}, { 4,     4, -3}, { 5,    13,  4}, 
  { 5,    12, -4}, { 6,    29,  5}, { 6,    28, -5}, { 7,    62,  6}, 
  { 7,    61, -6}, { 8,   126,  7}, { 8,   121, -7}, { 9,   255,  8}, 
  { 9,   254, -8}, {10,   483,  9}, {10,   482, -9}, {11,   963, 10}, 
  {11,   962,-10}, {12,  1923, 11}, {12,  1922,-11}, {12,  1921, 12}, 
  {12,  1920,-12}, { 0,     0,  0}
};

huff_entry_t bitalloc_e_25[] =
{
  { 2,     3,  0}, { 3,     3,  1}, { 3,     2, -1}, { 4,    11,  2}, 
  { 4,    10, -2}, { 4,     1,  3}, { 4,     0, -3}, { 5,    17,  4}, 
  { 5,    16, -4}, { 5,     5,  5}, { 5,     4, -5}, { 6,    38,  6}, 
  { 6,    37, -6}, { 6,    14,  7}, { 6,    13, -7}, { 7,    79,  8}, 
  { 7,    78, -8}, { 7,    72,  9}, { 7,    31, -9}, { 7,    25, 10}, 
  { 7,    24,-10}, { 8,   147, 11}, { 8,   146,-11}, { 8,    61, 12}, 
  { 8,    60,-12}, { 0,     0,  0}
};

huff_entry_t bitalloc_f_25[] =
{
  { 3,     1,  0}, { 3,     0,  1}, { 4,    15, -1}, { 4,    14,  2}, 
  { 4,    13, -2}, { 4,    11,  3}, { 4,    10, -3}, { 4,     8,  4}, 
  { 4,     7, -4}, { 4,     5,  5}, { 4,     4, -5}, { 5,    24,  6}, 
  { 5,    19, -6}, { 5,    13,  7}, { 5,    12, -7}, { 6,    37,  8}, 
  { 6,    36, -8}, { 7,   102,  9}, { 7,   101, -9}, { 8,   207, 10}, 
  { 8,   206,-10}, { 8,   200, 11}, { 9,   403,-11}, {10,   805, 12}, 
  {10,   804,-12}, { 0,     0,  0}
};

huff_entry_t bitalloc_g_25[] =
{
  { 2,     1,  0}, { 3,     6,  1}, { 3,     5, -1}, { 3,     0,  2}, 
  { 4,    15, -2}, { 4,     8,  3}, { 4,     3, -3}, { 5,    28,  4}, 
  { 5,    19, -4}, { 5,     4,  5}, { 6,    59, -5}, { 6,    36,  6}, 
  { 6,    11, -6}, { 7,   116,  7}, { 7,    75, -7}, { 7,    21,  8}, 
  { 7,    20, -8}, { 8,   149,  9}, { 8,   148, -9}, { 9,   470, 10}, 
  { 9,   469,-10}, {10,   943, 11}, {10,   942,-11}, {10,   937, 12}, 
  {10,   936,-12}, { 0,     0,  0}
};

huff_entry_t bitalloc_a_33[] =
{
  { 3,     2,  0}, { 3,     1,  1}, { 3,     0, -1}, { 4,    14,  2}, 
  { 4,    13, -2}, { 4,    12,  3}, { 4,    11, -3}, { 4,     9,  4}, 
  { 4,     8, -4}, { 4,     6,  5}, { 5,    31, -5}, { 5,    20,  6}, 
  { 5,    15, -6}, { 6,    61,  7}, { 6,    60, -7}, { 6,    29,  8}, 
  { 6,    28, -8}, { 7,    85,  9}, { 7,    84, -9}, { 8,   174, 10}, 
  { 8,   173,-10}, { 9,   351, 11}, { 9,   350,-11}, {10,   691, 12}, 
  {10,   690,-12}, {11,  1379, 13}, {11,  1378,-13}, {12,  2755, 14}, 
  {12,  2754,-14}, {13,  5507, 15}, {13,  5506,-15}, {13,  5505, 16}, 
  {13,  5504,-16}, { 0,     0,  0}
};

huff_entry_t bitalloc_b_33[] =
{
  { 3,     1,  0}, { 4,    15,  1}, { 4,    14, -1}, { 4,    11,  2}, 
  { 4,    10, -2}, { 4,     8,  3}, { 4,     7, -3}, { 4,     4,  4}, 
  { 4,     1, -4}, { 5,    27,  5}, { 5,    26, -5}, { 5,    19,  6}, 
  { 5,    18, -6}, { 5,    12,  7}, { 5,    11, -7}, { 5,     1,  8}, 
  { 5,     0, -8}, { 6,    50,  9}, { 6,    49, -9}, { 6,    26, 10}, 
  { 6,    21,-10}, { 7,   103, 11}, { 7,   102,-11}, { 7,    96, 12}, 
  { 7,    55,-12}, { 7,    41, 13}, { 7,    40,-13}, { 8,   194, 14}, 
  { 8,   109,-14}, { 8,   108, 15}, { 9,   391,-15}, {10,   781, 16}, 
  {10,   780,-16}, { 0,     0,  0}
};

huff_entry_t bitalloc_c_33[] =
{
  { 4,    13,  0}, { 4,    11,  1}, { 4,    10, -1}, { 4,     8,  2}, 
  { 4,     7, -2}, { 4,     4,  3}, { 4,     3, -3}, { 4,     2,  4}, 
  { 4,     1, -4}, { 5,    30,  5}, { 5,    29, -5}, { 5,    25,  6}, 
  { 5,    24, -6}, { 5,    19,  7}, { 5,    18, -7}, { 5,    11,  8}, 
  { 5,    10, -8}, { 5,     0,  9}, { 6,    63, -9}, { 6,    62, 10}, 
  { 6,    57,-10}, { 6,    27, 11}, { 6,    26,-11}, { 6,    24, 12}, 
  { 6,     3,-12}, { 7,   113, 13}, { 7,   112,-13}, { 7,    50, 14}, 
  { 7,     5,-14}, { 7,     4, 15}, { 8,   103,-15}, { 9,   205, 16}, 
  { 9,   204,-16}, { 0,     0,  0}
};

huff_entry_t bitalloc_d_33[] =
{
  { 2,     1,  0}, { 3,     6,  1}, { 3,     5, -1}, { 3,     0,  2}, 
  { 4,    15, -2}, { 4,     8,  3}, { 4,     3, -3}, { 5,    28,  4}, 
  { 5,    19, -4}, { 5,     4,  5}, { 6,    59, -5}, { 6,    36,  6}, 
  { 6,    11, -6}, { 7,   116,  7}, { 7,    75, -7}, { 7,    21,  8}, 
  { 7,    20, -8}, { 8,   149,  9}, { 8,   148, -9}, { 9,   469, 10}, 
  { 9,   468,-10}, {10,   941, 11}, {10,   940,-11}, {11,  1885, 12}, 
  {11,  1884,-12}, {12,  3773, 13}, {12,  3772,-13}, {13,  7551, 14}, 
  {13,  7550,-14}, {14, 15099, 15}, {14, 15098,-15}, {14, 15097, 16}, 
  {14, 15096,-16}, { 0,     0,  0}
};

huff_entry_t bitalloc_e_33[] =
{
  { 2,     2,  0}, { 3,     2,  1}, { 3,     1, -1}, { 4,    12,  2}, 
  { 4,     7, -2}, { 4,     0,  3}, { 5,    31, -3}, { 5,    27,  4}, 
  { 5,    26, -4}, { 5,     3,  5}, { 5,     2, -5}, { 6,    59,  6}, 
  { 6,    58, -6}, { 6,    27,  7}, { 6,    26, -7}, { 7,   123,  8}, 
  { 7,   122, -8}, { 7,   120,  9}, { 7,   115, -9}, { 7,   112, 10}, 
  { 7,    51,-10}, { 7,    49, 11}, { 7,    48,-11}, { 8,   242, 12}, 
  { 8,   229,-12}, { 8,   227, 13}, { 8,   226,-13}, { 8,   101, 14}, 
  { 8,   100,-14}, { 9,   487, 15}, { 9,   486,-15}, { 9,   457, 16}, 
  { 9,   456,-16}, { 0,     0,  0}
};

huff_entry_t bitalloc_f_33[] =
{
  { 4,    13,  0}, { 4,    12,  1}, { 4,    11, -1}, { 4,     9,  2}, 
  { 4,     8, -2}, { 4,     7,  3}, { 4,     6, -3}, { 4,     4,  4}, 
  { 4,     3, -4}, { 4,     1,  5}, { 4,     0, -5}, { 5,    30,  6}, 
  { 5,    29, -6}, { 5,    21,  7}, { 5,    20, -7}, { 5,    10,  8}, 
  { 5,     5, -8}, { 6,    63,  9}, { 6,    62, -9}, { 6,    56, 10}, 
  { 6,    23,-10}, { 6,     9, 11}, { 6,     8,-11}, { 7,    45, 12}, 
  { 7,    44,-12}, { 8,   230, 13}, { 8,   229,-13}, { 9,   463, 14}, 
  { 9,   462,-14}, { 9,   456, 15}, {10,   915,-15}, {11,  1829, 16}, 
  {11,  1828,-16}, { 0,     0,  0}
};

huff_entry_t bitalloc_g_33[] =
{
  { 3,     6,  0}, { 3,     3,  1}, { 3,     2, -1}, { 4,    15,  2}, 
  { 4,    14, -2}, { 4,     9,  3}, { 4,     8, -3}, { 4,     1,  4}, 
  { 4,     0, -4}, { 5,    22,  5}, { 5,    21, -5}, { 5,     6,  6}, 
  { 5,     5, -6}, { 6,    46,  7}, { 6,    41, -7}, { 6,    14,  8}, 
  { 6,     9, -8}, { 7,    94,  9}, { 7,    81, -9}, { 7,    30, 10}, 
  { 7,    17,-10}, { 8,   191, 11}, { 8,   190,-11}, { 8,    63, 12}, 
  { 8,    62,-12}, { 8,    32, 13}, { 9,   323,-13}, { 9,   321, 14}, 
  { 9,   320,-14}, { 9,    67, 15}, { 9,    66,-15}, {10,   645, 16}, 
  {10,   644,-16}, { 0,     0,  0}
};

huff_entry_t bitalloc_a_65[] =
{
  { 4,     6,  0}, { 4,     5,  1}, { 4,     4, -1}, { 4,     2,  2}, 
  { 4,     1, -2}, { 4,     0,  3}, { 5,    31, -3}, { 5,    29,  4}, 
  { 5,    28, -4}, { 5,    27,  5}, { 5,    26, -5}, { 5,    24,  6}, 
  { 5,    23, -6}, { 5,    21,  7}, { 5,    20, -7}, { 5,    18,  8}, 
  { 5,    17, -8}, { 5,    14,  9}, { 5,     7, -9}, { 5,     6, 10}, 
  { 6,    61,-10}, { 6,    50, 11}, { 6,    45,-11}, { 6,    38, 12}, 
  { 6,    33,-12}, { 6,    31, 13}, { 6,    30,-13}, { 7,   120, 14}, 
  { 7,   103,-14}, { 7,    89, 15}, { 7,    88,-15}, { 7,    65, 16}, 
  { 7,    64,-16}, { 8,   205, 17}, { 8,   204,-17}, { 8,   157, 18}, 
  { 8,   156,-18}, { 9,   486, 19}, { 9,   485,-19}, { 9,   318, 20}, 
  { 9,   317,-20}, {10,   975, 21}, {10,   974,-21}, {10,   639, 22}, 
  {10,   638,-22}, {11,  1939, 23}, {11,  1938,-23}, {11,  1936, 24}, 
  {11,  1267,-24}, {11,  1264, 25}, {12,  3875,-25}, {12,  2532, 26}, 
  {12,  2531,-26}, {13,  7749, 27}, {13,  7748,-27}, {13,  5061, 28}, 
  {13,  5060,-28}, {14, 10133, 29}, {14, 10132,-29}, {15, 20269, 30}, 
  {15, 20268,-30}, {16, 40543, 31}, {16, 40542,-31}, {16, 40541, 32}, 
  {16, 40540,-32}, { 0,     0,  0}
};

huff_entry_t bitalloc_b_65[] =
{
  { 4,     4,  0}, { 4,     2,  1}, { 4,     1, -1}, { 5,    30,  2}, 
  { 5,    29, -2}, { 5,    26,  3}, { 5,    25, -3}, { 5,    23,  4}, 
  { 5,    22, -4}, { 5,    19,  5}, { 5,    18, -5}, { 5,    16,  6}, 
  { 5,    15, -6}, { 5,    12,  7}, { 5,    11, -7}, { 5,     7,  8}, 
  { 5,     6, -8}, { 6,    63,  9}, { 6,    62, -9}, { 6,    56, 10}, 
  { 6,    55,-10}, { 6,    49, 11}, { 6,    48,-11}, { 6,    41, 12}, 
  { 6,    40,-12}, { 6,    34, 13}, { 6,    29,-13}, { 6,    26, 14}, 
  { 6,    21,-14}, { 6,    20, 15}, { 6,     3,-15}, { 6,     0, 16}, 
  { 7,   115,-16}, { 7,   109, 17}, { 7,   108,-17}, { 7,    86, 18}, 
  { 7,    85,-18}, { 7,    70, 19}, { 7,    57,-19}, { 7,    56, 20}, 
  { 7,    55,-20}, { 7,     4, 21}, { 7,     3,-21}, { 8,   229, 22}, 
  { 8,   228,-22}, { 8,   175, 23}, { 8,   174,-23}, { 8,   143, 24}, 
  { 8,   142,-24}, { 8,   108, 25}, { 8,    11,-25}, { 8,    10, 26}, 
  { 8,     5,-26}, { 9,   339, 27}, { 9,   338,-27}, { 9,   336, 28}, 
  { 9,   219,-28}, { 9,     9, 29}, { 9,     8,-29}, {10,   674, 30}, 
  {10,   437,-30}, {10,   436, 31}, {11,  1351,-31}, {12,  2701, 32}, 
  {12,  2700,-32}, { 0,     0,  0}
};

huff_entry_t bitalloc_c_65[] =
{
  { 5,    28,  0}, { 5,    25,  1}, { 5,    24, -1}, { 5,    23,  2}, 
  { 5,    22, -2}, { 5,    19,  3}, { 5,    18, -3}, { 5,    16,  4}, 
  { 5,    15, -4}, { 5,    13,  5}, { 5,    12, -5}, { 5,    10,  6}, 
  { 5,     9, -6}, { 5,     7,  7}, { 5,     6, -7}, { 5,     4,  8}, 
  { 5,     3, -8}, { 5,     1,  9}, { 5,     0, -9}, { 6,    62, 10}, 
  { 6,    61,-10}, { 6,    59, 11}, { 6,    58,-11}, { 6,    54, 12}, 
  { 6,    53,-12}, { 6,    43, 13}, { 6,    42,-13}, { 6,    40, 14}, 
  { 6,    35,-14}, { 6,    29, 15}, { 6,    28,-15}, { 6,    17, 16}, 
  { 6,    16,-16}, { 6,    11, 17}, { 6,    10,-17}, { 6,     4, 18}, 
  { 7,   127,-18}, { 7,   121, 19}, { 7,   120,-19}, { 7,   110, 20}, 
  { 7,   105,-20}, { 7,    83, 21}, { 7,    82,-21}, { 7,    68, 22}, 
  { 7,    47,-22}, { 7,    46, 23}, { 7,    45,-23}, { 7,    11, 24}, 
  { 7,    10,-24}, { 8,   252, 25}, { 8,   223,-25}, { 8,   209, 26}, 
  { 8,   208,-26}, { 8,   138, 27}, { 8,    89,-27}, { 8,    88, 28}, 
  { 9,   507,-28}, { 9,   445, 29}, { 9,   444,-29}, { 9,   278, 30}, 
  {10,  1013,-30}, {10,  1012, 31}, {10,   559,-31}, {11,  1117, 32}, 
  {11,  1116,-32}, { 0,     0,  0}
};

huff_entry_t bitalloc_d_65[] =
{
  { 3,     4,  0}, { 3,     1,  1}, { 3,     0, -1}, { 4,    13,  2}, 
  { 4,    12, -2}, { 4,     7,  3}, { 4,     6, -3}, { 5,    31,  4}, 
  { 5,    30, -4}, { 5,    23,  5}, { 5,    22, -5}, { 5,    11,  6}, 
  { 5,    10, -6}, { 6,    59,  7}, { 6,    58, -7}, { 6,    43,  8}, 
  { 6,    42, -8}, { 6,    19,  9}, { 6,    18, -9}, { 7,   115, 10}, 
  { 7,   114,-10}, { 7,    83, 11}, { 7,    82,-11}, { 7,    35, 12}, 
  { 7,    34,-12}, { 8,   227, 13}, { 8,   226,-13}, { 8,   163, 14}, 
  { 8,   162,-14}, { 8,   160, 15}, { 8,    67,-15}, { 8,    64, 16}, 
  { 9,   451,-16}, { 9,   448, 17}, { 9,   323,-17}, { 9,   132, 18}, 
  { 9,   131,-18}, {10,   900, 19}, {10,   899,-19}, {10,   644, 20}, 
  {10,   267,-20}, {10,   261, 21}, {10,   260,-21}, {11,  1797, 22}, 
  {11,  1796,-22}, {11,   533, 23}, {11,   532,-23}, {12,  3605, 24}, 
  {12,  3604,-24}, {12,  2582, 25}, {12,  2581,-25}, {13,  7215, 26}, 
  {13,  7214,-26}, {13,  5167, 27}, {13,  5166,-27}, {13,  5160, 28}, 
  {14, 14427,-28}, {14, 10323, 29}, {14, 10322,-29}, {15, 28853, 30}, 
  {15, 28852,-30}, {15, 28851, 31}, {15, 28850,-31}, {15, 28849, 32}, 
  {15, 28848,-32}, { 0,     0,  0}
};

huff_entry_t bitalloc_e_65[] =
{
  { 3,     4,  0}, { 3,     0,  1}, { 4,    15, -1}, { 4,     7,  2}, 
  { 4,     6, -2}, { 5,    29,  3}, { 5,    28, -3}, { 5,    23,  4}, 
  { 5,    22, -4}, { 5,    10,  5}, { 5,     9, -5}, { 5,     6,  6}, 
  { 5,     5, -6}, { 6,    54,  7}, { 6,    53, -7}, { 6,    48,  8}, 
  { 6,    43, -8}, { 6,    40,  9}, { 6,    23, -9}, { 6,    16, 10}, 
  { 6,    15,-10}, { 6,     9, 11}, { 6,     8,-11}, { 7,   105, 12}, 
  { 7,   104,-12}, { 7,   100, 13}, { 7,    99,-13}, { 7,    84, 14}, 
  { 7,    83,-14}, { 7,    45, 15}, { 7,    44,-15}, { 7,    29, 16}, 
  { 7,    28,-16}, { 8,   221, 17}, { 8,   220,-17}, { 8,   206, 18}, 
  { 8,   205,-18}, { 8,   202, 19}, { 8,   197,-19}, { 8,   171, 20}, 
  { 8,   170,-20}, { 8,   164, 21}, { 8,    71,-21}, { 8,    69, 22}, 
  { 8,    68,-22}, { 9,   446, 23}, { 9,   445,-23}, { 9,   415, 24}, 
  { 9,   414,-24}, { 9,   408, 25}, { 9,   407,-25}, { 9,   393, 26}, 
  { 9,   392,-26}, { 9,   331, 27}, { 9,   330,-27}, { 9,   141, 28}, 
  { 9,   140,-28}, {10,   895, 29}, {10,   894,-29}, {10,   889, 30}, 
  {10,   888,-30}, {10,   819, 31}, {10,   818,-31}, {10,   813, 32}, 
  {10,   812,-32}, { 0,     0,  0}
};

huff_entry_t bitalloc_f_65[] =
{
  { 3,     6,  0}, { 3,     3,  1}, { 3,     2, -1}, { 4,    15,  2}, 
  { 4,    14, -2}, { 4,     9,  3}, { 4,     8, -3}, { 4,     1,  4}, 
  { 4,     0, -4}, { 5,    21,  5}, { 5,    20, -5}, { 5,     5,  6}, 
  { 5,     4, -6}, { 6,    45,  7}, { 6,    44, -7}, { 6,    13,  8}, 
  { 6,    12, -8}, { 7,    93,  9}, { 7,    92, -9}, { 7,    29, 10}, 
  { 7,    28,-10}, { 8,   189, 11}, { 8,   188,-11}, { 8,    61, 12}, 
  { 8,    60,-12}, { 9,   381, 13}, { 9,   380,-13}, { 9,   125, 14}, 
  { 9,   124,-14}, {10,   765, 15}, {10,   764,-15}, {10,   252, 16}, 
  {11,  1535,-16}, {11,  1532, 17}, {11,   511,-17}, {11,   506, 18}, 
  {12,  3069,-18}, {12,  3067, 19}, {12,  3066,-19}, {12,  1015, 20}, 
  {12,  1014,-20}, {13,  6136, 21}, {13,  2043,-21}, {13,  2035, 22}, 
  {13,  2034,-22}, {14, 12275, 23}, {14, 12274,-23}, {14,  4085, 24}, 
  {14,  4084,-24}, {14,  4083, 25}, {14,  4082,-25}, {14,  4081, 26}, 
  {14,  4080,-26}, {14,  4079, 27}, {14,  4078,-27}, {14,  4077, 28}, 
  {14,  4076,-28}, {14,  4075, 29}, {14,  4074,-29}, {14,  4073, 30}, 
  {14,  4072,-30}, {14,  4067, 31}, {14,  4066,-31}, {14,  4065, 32}, 
  {14,  4064,-32}, { 0,     0,  0}
};

huff_entry_t bitalloc_g_65[] =
{
  { 4,    14,  0}, { 4,    11,  1}, { 4,    10, -1}, { 4,     8,  2}, 
  { 4,     6, -2}, { 4,     4,  3}, { 4,     3, -3}, { 4,     0,  4}, 
  { 5,    31, -4}, { 5,    26,  5}, { 5,    25, -5}, { 5,    18,  6}, 
  { 5,    15, -6}, { 5,    10,  7}, { 5,     5, -7}, { 5,     2,  8}, 
  { 6,    61, -8}, { 6,    54,  9}, { 6,    49, -9}, { 6,    38, 10}, 
  { 6,    29,-10}, { 6,    22, 11}, { 6,     9,-11}, { 6,     6, 12}, 
  { 7,   121,-12}, { 7,   110, 13}, { 7,    97,-13}, { 7,    78, 14}, 
  { 7,    57,-14}, { 7,    46, 15}, { 7,    17,-15}, { 7,    14, 16}, 
  { 8,   241,-16}, { 8,   223, 17}, { 8,   222,-17}, { 8,   159, 18}, 
  { 8,   158,-18}, { 8,    95, 19}, { 8,    94,-19}, { 8,    31, 20}, 
  { 8,    30,-20}, { 9,   480, 21}, { 9,   387,-21}, { 9,   384, 22}, 
  { 9,   227,-22}, { 9,   225, 23}, { 9,   224,-23}, { 9,    65, 24}, 
  { 9,    64,-24}, {10,   962, 25}, {10,   773,-25}, {10,   771, 26}, 
  {10,   770,-26}, {10,   452, 27}, {10,   135,-27}, {10,   133, 28}, 
  {10,   132,-28}, {11,  1927, 29}, {11,  1926,-29}, {11,  1545, 30}, 
  {11,  1544,-30}, {11,   907, 31}, {11,   906,-31}, {11,   269, 32}, 
  {11,   268,-32}, { 0,     0,  0}
};

huff_entry_t bitalloc_a_129[] =
{
  { 4,     8,  0}, { 4,    10,  1}, { 4,     9, -1}, { 4,     0,  2}, 
  { 5,    31, -2}, { 5,    24,  3}, { 5,    23, -3}, { 5,    12,  4}, 
  { 5,    11, -4}, { 5,     5,  5}, { 5,     4, -5}, { 6,    60,  6}, 
  { 6,    58, -6}, { 6,    54,  7}, { 6,    53, -7}, { 6,    45,  8}, 
  { 6,    44, -8}, { 6,    28,  9}, { 6,    27, -9}, { 6,    19, 10}, 
  { 6,    18,-10}, { 6,    14, 11}, { 6,    13,-11}, { 6,     6, 12}, 
  { 6,     5,-12}, { 7,   122, 13}, { 7,   119,-13}, { 7,   113, 14}, 
  { 7,   112,-14}, { 7,   104, 15}, { 7,   103,-15}, { 7,   100, 16}, 
  { 7,    63,-16}, { 7,    60, 17}, { 7,    59,-17}, { 7,    52, 18}, 
  { 7,    43,-18}, { 7,    40, 19}, { 7,    35,-19}, { 7,    32, 20}, 
  { 7,    31,-20}, { 7,    15, 21}, { 7,    14,-21}, { 8,   247, 22}, 
  { 8,   246,-22}, { 8,   231, 23}, { 8,   230,-23}, { 8,   223, 24}, 
  { 8,   222,-24}, { 8,   211, 25}, { 8,   210,-25}, { 8,   203, 26}, 
  { 8,   202,-26}, { 8,   123, 27}, { 8,   122,-27}, { 8,   116, 28}, 
  { 8,   107,-28}, { 8,    84, 29}, { 8,    83,-29}, { 8,    68, 30}, 
  { 8,    67,-30}, { 8,    60, 31}, { 8,    51,-31}, { 8,    49, 32}, 
  { 8,    48,-32}, { 8,    17, 33}, { 8,    16,-33}, { 9,   474, 34}, 
  { 9,   473,-34}, { 9,   458, 35}, { 9,   457,-35}, { 9,   442, 36}, 
  { 9,   441,-36}, { 9,   411, 37}, { 9,   410,-37}, { 9,   251, 38}, 
  { 9,   250,-38}, { 9,   248, 39}, { 9,   235,-39}, { 9,   213, 40}, 
  { 9,   212,-40}, { 9,   170, 41}, { 9,   165,-41}, { 9,   139, 42}, 
  { 9,   138,-42}, { 9,   132, 43}, { 9,   123,-43}, { 9,   101, 44}, 
  { 9,   100,-44}, { 9,    37, 45}, { 9,    36,-45}, {10,   950, 46}, 
  {10,   945,-46}, {10,   919, 47}, {10,   918,-47}, {10,   912, 48}, 
  {10,   887,-48}, {10,   881, 49}, {10,   880,-49}, {10,   818, 50}, 
  {10,   817,-50}, {10,   499, 51}, {10,   498,-51}, {10,   469, 52}, 
  {10,   468,-52}, {10,   343, 53}, {10,   342,-53}, {10,   329, 54}, 
  {10,   328,-54}, {10,   267, 55}, {10,   266,-55}, {10,   245, 56}, 
  {10,   244,-56}, {10,    79, 57}, {10,    78,-57}, {10,    77, 58}, 
  {10,    76,-58}, {11,  1903, 59}, {11,  1902,-59}, {11,  1889, 60}, 
  {11,  1888,-60}, {11,  1827, 61}, {11,  1826,-61}, {11,  1773, 62}, 
  {11,  1772,-62}, {11,  1639, 63}, {11,  1638,-63}, {11,  1633, 64}, 
  {11,  1632,-64}, { 0,     0,  0}
};

huff_entry_t bitalloc_b_129[] =
{
  { 5,    10,  0}, { 5,     7,  1}, { 5,     6, -1}, { 5,     4,  2}, 
  { 5,     3, -2}, { 5,     0,  3}, { 6,    63, -3}, { 6,    60,  4}, 
  { 6,    59, -4}, { 6,    57,  5}, { 6,    56, -5}, { 6,    53,  6}, 
  { 6,    52, -6}, { 6,    50,  7}, { 6,    49, -7}, { 6,    46,  8}, 
  { 6,    45, -8}, { 6,    43,  9}, { 6,    42, -9}, { 6,    39, 10}, 
  { 6,    38,-10}, { 6,    35, 11}, { 6,    34,-11}, { 6,    32, 12}, 
  { 6,    31,-12}, { 6,    28, 13}, { 6,    27,-13}, { 6,    25, 14}, 
  { 6,    24,-14}, { 6,    22, 15}, { 6,    19,-15}, { 6,    16, 16}, 
  { 6,    11,-16}, { 6,     5, 17}, { 6,     4,-17}, { 7,   125, 18}, 
  { 7,   124,-18}, { 7,   122, 19}, { 7,   117,-19}, { 7,   110, 20}, 
  { 7,   109,-20}, { 7,   103, 21}, { 7,   102,-21}, { 7,    96, 22}, 
  { 7,    95,-22}, { 7,    89, 23}, { 7,    88,-23}, { 7,    81, 24}, 
  { 7,    80,-24}, { 7,    74, 25}, { 7,    73,-25}, { 7,    66, 26}, 
  { 7,    61,-26}, { 7,    59, 27}, { 7,    58,-27}, { 7,    52, 28}, 
  { 7,    47,-28}, { 7,    37, 29}, { 7,    36,-29}, { 7,    21, 30}, 
  { 7,    20,-30}, { 7,     6, 31}, { 7,     5,-31}, { 8,   247, 32}, 
  { 8,   246,-32}, { 8,   223, 33}, { 8,   222,-33}, { 8,   217, 34}, 
  { 8,   216,-34}, { 8,   189, 35}, { 8,   188,-35}, { 8,   166, 36}, 
  { 8,   165,-36}, { 8,   151, 37}, { 8,   150,-37}, { 8,   144, 38}, 
  { 8,   135,-38}, { 8,   121, 39}, { 8,   120,-39}, { 8,   106, 40}, 
  { 8,    93,-40}, { 8,    71, 41}, { 8,    70,-41}, { 8,    68, 42}, 
  { 8,    15,-42}, { 8,     9, 43}, { 8,     8,-43}, { 9,   466, 44}, 
  { 9,   465,-44}, { 9,   391, 45}, { 9,   390,-45}, { 9,   388, 46}, 
  { 9,   335,-46}, { 9,   329, 47}, { 9,   328,-47}, { 9,   269, 48}, 
  { 9,   268,-48}, { 9,   215, 49}, { 9,   214,-49}, { 9,   184, 50}, 
  { 9,   139,-50}, { 9,    29, 51}, { 9,    28,-51}, {10,   934, 52}, 
  {10,   929,-52}, {10,   779, 53}, {10,   778,-53}, {10,   668, 54}, 
  {10,   583,-54}, {10,   582, 55}, {10,   581,-55}, {10,   371, 56}, 
  {10,   370,-56}, {10,   276, 57}, {11,  1871,-57}, {11,  1857, 58}, 
  {11,  1856,-58}, {11,  1338, 59}, {11,  1161,-59}, {11,  1160, 60}, 
  {11,   555,-60}, {12,  3741, 61}, {12,  3740,-61}, {12,  2678, 62}, 
  {12,  1109,-62}, {12,  1108, 63}, {13,  5359,-63}, {14, 10717, 64}, 
  {14, 10716,-64}, { 0,     0,  0}
};

huff_entry_t bitalloc_c_129[] =
{
  { 6,    58,  0}, { 6,    55,  1}, { 6,    54, -1}, { 6,    52,  2}, 
  { 6,    51, -2}, { 6,    49,  3}, { 6,    48, -3}, { 6,    46,  4}, 
  { 6,    45, -4}, { 6,    43,  5}, { 6,    42, -5}, { 6,    40,  6}, 
  { 6,    39, -6}, { 6,    37,  7}, { 6,    36, -7}, { 6,    34,  8}, 
  { 6,    33, -8}, { 6,    30,  9}, { 6,    29, -9}, { 6,    27, 10}, 
  { 6,    26,-10}, { 6,    24, 11}, { 6,    23,-11}, { 6,    21, 12}, 
  { 6,    20,-12}, { 6,    18, 13}, { 6,    17,-13}, { 6,    14, 14}, 
  { 6,    13,-14}, { 6,    12, 15}, { 6,    11,-15}, { 6,     8, 16}, 
  { 6,     7,-16}, { 6,     6, 17}, { 6,     5,-17}, { 6,     3, 18}, 
  { 6,     2,-18}, { 7,   127, 19}, { 7,   126,-19}, { 7,   124, 20}, 
  { 7,   123,-20}, { 7,   121, 21}, { 7,   120,-21}, { 7,   118, 22}, 
  { 7,   115,-22}, { 7,   113, 23}, { 7,   112,-23}, { 7,   106, 24}, 
  { 7,   101,-24}, { 7,    95, 25}, { 7,    94,-25}, { 7,    88, 26}, 
  { 7,    83,-26}, { 7,    77, 27}, { 7,    76,-27}, { 7,    70, 28}, 
  { 7,    65,-28}, { 7,    64, 29}, { 7,    63,-29}, { 7,    56, 30}, 
  { 7,    51,-30}, { 7,    45, 31}, { 7,    44,-31}, { 7,    39, 32}, 
  { 7,    38,-32}, { 7,    31, 33}, { 7,    30,-33}, { 7,    20, 34}, 
  { 7,    19,-34}, { 7,    18, 35}, { 7,     9,-35}, { 7,     3, 36}, 
  { 7,     2,-36}, { 7,     0, 37}, { 8,   251,-37}, { 8,   245, 38}, 
  { 8,   244,-38}, { 8,   238, 39}, { 8,   229,-39}, { 8,   215, 40}, 
  { 8,   214,-40}, { 8,   200, 41}, { 8,   179,-41}, { 8,   165, 42}, 
  { 8,   164,-42}, { 8,   143, 43}, { 8,   142,-43}, { 8,   124, 44}, 
  { 8,   115,-44}, { 8,   101, 45}, { 8,   100,-45}, { 8,    66, 46}, 
  { 8,    65,-46}, { 8,    43, 47}, { 8,    42,-47}, { 8,    17, 48}, 
  { 8,    16,-48}, { 8,     2, 49}, { 9,   501,-49}, { 9,   479, 50}, 
  { 9,   478,-50}, { 9,   456, 51}, { 9,   403,-51}, { 9,   357, 52}, 
  { 9,   356,-52}, { 9,   251, 53}, { 9,   250,-53}, { 9,   228, 54}, 
  { 9,   135,-54}, { 9,   129, 55}, { 9,   128,-55}, { 9,     6, 56}, 
  {10,  1001,-56}, {10,  1000, 57}, {10,   915,-57}, {10,   805, 58}, 
  {10,   804,-58}, {10,   458, 59}, {10,   269,-59}, {10,   268, 60}, 
  {10,    15,-60}, {11,  1829, 61}, {11,  1828,-61}, {11,   918, 62}, 
  {11,    29,-62}, {11,    28, 63}, {12,  1839,-63}, {13,  3677, 64}, 
  {13,  3676,-64}, { 0,     0,  0}
};

huff_entry_t bitalloc_d_129[] =
{
  { 4,     9,  0}, { 4,     6,  1}, { 4,     5, -1}, { 4,     2,  2}, 
  { 4,     1, -2}, { 5,    30,  3}, { 5,    29, -3}, { 5,    26,  4}, 
  { 5,    25, -4}, { 5,    22,  5}, { 5,    21, -5}, { 5,    16,  6}, 
  { 5,    15, -6}, { 5,     8,  7}, { 5,     7, -7}, { 5,     0,  8}, 
  { 6,    63, -8}, { 6,    56,  9}, { 6,    55, -9}, { 6,    48, 10}, 
  { 6,    47,-10}, { 6,    40, 11}, { 6,    35,-11}, { 6,    28, 12}, 
  { 6,    19,-12}, { 6,    12, 13}, { 6,     3,-13}, { 7,   124, 14}, 
  { 7,   115,-14}, { 7,   108, 15}, { 7,    99,-15}, { 7,    92, 16}, 
  { 7,    83,-16}, { 7,    68, 17}, { 7,    59,-17}, { 7,    36, 18}, 
  { 7,    27,-18}, { 7,     4, 19}, { 8,   251,-19}, { 8,   228, 20}, 
  { 8,   219,-20}, { 8,   196, 21}, { 8,   187,-21}, { 8,   164, 22}, 
  { 8,   139,-22}, { 8,   116, 23}, { 8,    75,-23}, { 8,    52, 24}, 
  { 8,    11,-24}, { 9,   501, 25}, { 9,   500,-25}, { 9,   437, 26}, 
  { 9,   436,-26}, { 9,   373, 27}, { 9,   372,-27}, { 9,   277, 28}, 
  { 9,   276,-28}, { 9,   149, 29}, { 9,   148,-29}, { 9,    21, 30}, 
  { 9,    20,-30}, {10,   917, 31}, {10,   916,-31}, {10,   789, 32}, 
  {10,   788,-32}, {10,   661, 33}, {10,   660,-33}, {10,   469, 34}, 
  {10,   468,-34}, {10,   214, 35}, {10,   213,-35}, {11,  1838, 36}, 
  {11,  1837,-36}, {11,  1582, 37}, {11,  1581,-37}, {11,  1326, 38}, 
  {11,  1325,-38}, {11,   942, 39}, {11,   941,-39}, {11,   431, 40}, 
  {11,   430,-40}, {12,  3679, 41}, {12,  3678,-41}, {12,  3167, 42}, 
  {12,  3166,-42}, {12,  3160, 43}, {12,  2655,-43}, {12,  2648, 44}, 
  {12,  1887,-44}, {12,  1880, 45}, {12,   851,-45}, {12,   849, 46}, 
  {12,   848,-46}, {13,  7346, 47}, {13,  7345,-47}, {13,  6322, 48}, 
  {13,  5309,-48}, {13,  3773, 49}, {13,  3772,-49}, {13,  3762, 50}, 
  {13,  1701,-50}, {14, 14695, 51}, {14, 14694,-51}, {14, 14688, 52}, 
  {14, 12647,-52}, {14, 10617, 53}, {14, 10616,-53}, {14, 10596, 54}, 
  {14,  7527,-54}, {14,  3401, 55}, {14,  3400,-55}, {15, 29378, 56}, 
  {15, 25293,-56}, {15, 21195, 57}, {15, 21194,-57}, {15, 15053, 58}, 
  {15, 15052,-58}, {16, 58759, 59}, {16, 58758,-59}, {16, 50585, 60}, 
  {16, 50584,-60}, {16, 42399, 61}, {16, 42398,-61}, {16, 42397, 62}, 
  {16, 42396,-62}, {16, 42395, 63}, {16, 42394,-63}, {16, 42393, 64}, 
  {16, 42392,-64}, { 0,     0,  0}
};

huff_entry_t bitalloc_e_129[] =
{
  { 5,    12,  0}, { 5,    11,  1}, { 5,    10, -1}, { 5,     9,  2}, 
  { 5,     8, -2}, { 5,     7,  3}, { 5,     6, -3}, { 5,     4,  4}, 
  { 5,     3, -4}, { 5,     2,  5}, { 5,     1, -5}, { 5,     0,  6}, 
  { 6,    63, -6}, { 6,    61,  7}, { 6,    60, -7}, { 6,    59,  8}, 
  { 6,    58, -8}, { 6,    56,  9}, { 6,    55, -9}, { 6,    53, 10}, 
  { 6,    52,-10}, { 6,    51, 11}, { 6,    50,-11}, { 6,    47, 12}, 
  { 6,    46,-12}, { 6,    45, 13}, { 6,    44,-13}, { 6,    42, 14}, 
  { 6,    41,-14}, { 6,    38, 15}, { 6,    37,-15}, { 6,    36, 16}, 
  { 6,    35,-16}, { 6,    32, 17}, { 6,    31,-17}, { 6,    29, 18}, 
  { 6,    28,-18}, { 6,    26, 19}, { 6,    11,-19}, { 7,   125, 20}, 
  { 7,   124,-20}, { 7,   109, 21}, { 7,   108,-21}, { 7,    98, 22}, 
  { 7,    97,-22}, { 7,    87, 23}, { 7,    86,-23}, { 7,    79, 24}, 
  { 7,    78,-24}, { 7,    68, 25}, { 7,    67,-25}, { 7,    60, 26}, 
  { 7,    55,-26}, { 7,    21, 27}, { 7,    20,-27}, { 8,   230, 28}, 
  { 8,   229,-28}, { 8,   198, 29}, { 8,   193,-29}, { 8,   163, 30}, 
  { 8,   162,-30}, { 8,   139, 31}, { 8,   138,-31}, { 8,   123, 32}, 
  { 8,   122,-32}, { 8,   108, 33}, { 9,   463,-33}, { 9,   457, 34}, 
  { 9,   456,-34}, { 9,   385, 35}, { 9,   384,-35}, { 9,   321, 36}, 
  { 9,   320,-36}, { 9,   266, 37}, { 9,   265,-37}, { 9,   218, 38}, 
  {10,   925,-38}, {10,   798, 39}, {10,   797,-39}, {10,   646, 40}, 
  {10,   645,-40}, {10,   535, 41}, {10,   534,-41}, {10,   528, 42}, 
  {10,   439,-42}, {11,  1848, 43}, {11,  1599,-43}, {11,  1592, 44}, 
  {11,  1295,-44}, {11,  1288, 45}, {11,  1059,-45}, {11,   877, 46}, 
  {11,   876,-46}, {12,  3197, 47}, {12,  3196,-47}, {12,  2589, 48}, 
  {12,  2588,-48}, {12,  2117, 49}, {12,  2116,-49}, {13,  7398, 50}, 
  {13,  7397,-50}, {13,  6374, 51}, {13,  6373,-51}, {13,  5158, 52}, 
  {13,  5157,-52}, {14, 14799, 53}, {14, 14798,-53}, {14, 12751, 54}, 
  {14, 12750,-54}, {14, 10318, 55}, {14, 10313,-55}, {15, 29587, 56}, 
  {15, 29586,-56}, {15, 29584, 57}, {15, 25491,-57}, {15, 20625, 58}, 
  {15, 20624,-58}, {16, 59171, 59}, {16, 59170,-59}, {16, 50980, 60}, 
  {16, 41277,-60}, {16, 50981, 61}, {16, 41278,-61}, {16, 50978, 62}, 
  {16, 41279,-62}, {16, 50979, 63}, {16, 50976,-63}, {16, 50977, 64}, 
  {16, 41276,-64}, { 0,     0,  0}
};

huff_entry_t bitalloc_f_129[] =
{
  { 6,    56,  0}, { 6,    55,  1}, { 6,    54, -1}, { 6,    52,  2}, 
  { 6,    51, -2}, { 6,    50,  3}, { 6,    49, -3}, { 6,    48,  4}, 
  { 6,    47, -4}, { 6,    46,  5}, { 6,    45, -5}, { 6,    44,  6}, 
  { 6,    43, -6}, { 6,    41,  7}, { 6,    40, -7}, { 6,    39,  8}, 
  { 6,    38, -8}, { 6,    36,  9}, { 6,    35, -9}, { 6,    34, 10}, 
  { 6,    33,-10}, { 6,    31, 11}, { 6,    30,-11}, { 6,    29, 12}, 
  { 6,    28,-12}, { 6,    26, 13}, { 6,    25,-13}, { 6,    23, 14}, 
  { 6,    22,-14}, { 6,    21, 15}, { 6,    20,-15}, { 6,    18, 16}, 
  { 6,    17,-16}, { 6,    15, 17}, { 6,    14,-17}, { 6,    12, 18}, 
  { 6,    11,-18}, { 6,     9, 19}, { 6,     8,-19}, { 6,     7, 20}, 
  { 6,     6,-20}, { 6,     3, 21}, { 6,     2,-21}, { 6,     1, 22}, 
  { 6,     0,-22}, { 7,   125, 23}, { 7,   124,-23}, { 7,   123, 24}, 
  { 7,   122,-24}, { 7,   120, 25}, { 7,   119,-25}, { 7,   116, 26}, 
  { 7,   115,-26}, { 7,   114, 27}, { 7,   107,-27}, { 7,    84, 28}, 
  { 7,    75,-28}, { 7,    65, 29}, { 7,    64,-29}, { 7,    54, 30}, 
  { 7,    49,-30}, { 7,    39, 31}, { 7,    38,-31}, { 7,    27, 32}, 
  { 7,    26,-32}, { 7,    20, 33}, { 7,    11,-33}, { 7,    10, 34}, 
  { 7,     9,-34}, { 8,   254, 35}, { 8,   253,-35}, { 8,   243, 36}, 
  { 8,   242,-36}, { 8,   235, 37}, { 8,   234,-37}, { 8,   213, 38}, 
  { 8,   212,-38}, { 8,   149, 39}, { 8,   148,-39}, { 8,   110, 40}, 
  { 8,    97,-40}, { 8,    66, 41}, { 8,    65,-41}, { 8,    43, 42}, 
  { 8,    42,-42}, { 8,    16, 43}, { 9,   511,-43}, { 9,   505, 44}, 
  { 9,   504,-44}, { 9,   474, 45}, { 9,   473,-45}, { 9,   343, 46}, 
  { 9,   342,-46}, { 9,   340, 47}, { 9,   223,-47}, { 9,   192, 48}, 
  { 9,   135,-48}, { 9,   129, 49}, { 9,   128,-49}, { 9,    34, 50}, 
  {10,  1021,-50}, {10,   951, 51}, {10,   950,-51}, {10,   944, 52}, 
  {10,   683,-52}, {10,   445, 53}, {10,   444,-53}, {10,   269, 54}, 
  {10,   268,-54}, {10,    71, 55}, {10,    70,-55}, {11,  2040, 56}, 
  {11,  1891,-56}, {11,  1364, 57}, {11,   775,-57}, {11,   774, 58}, 
  {11,   773,-58}, {12,  4083, 59}, {12,  4082,-59}, {12,  3780, 60}, 
  {12,  2731,-60}, {12,  1545, 61}, {12,  1544,-61}, {13,  7562, 62}, 
  {13,  5461,-62}, {13,  5460, 63}, {14, 15127,-63}, {15, 30253, 64}, 
  {15, 30252,-64}, { 0,     0,  0}
};

huff_entry_t bitalloc_g_129[] =
{
  { 4,     0,  0}, { 5,    29,  1}, { 5,    28, -1}, { 5,    25,  2}, 
  { 5,    24, -2}, { 5,    21,  3}, { 5,    20, -3}, { 5,    17,  4}, 
  { 5,    16, -4}, { 5,    13,  5}, { 5,    12, -5}, { 5,     9,  6}, 
  { 5,     8, -6}, { 5,     5,  7}, { 5,     4, -7}, { 6,    63,  8}, 
  { 6,    62, -8}, { 6,    55,  9}, { 6,    54, -9}, { 6,    47, 10}, 
  { 6,    46,-10}, { 6,    39, 11}, { 6,    38,-11}, { 6,    31, 12}, 
  { 6,    30,-12}, { 6,    23, 13}, { 6,    22,-13}, { 6,    15, 14}, 
  { 6,    14,-14}, { 6,     7, 15}, { 6,     6,-15}, { 7,   123, 16}, 
  { 7,   122,-16}, { 7,   107, 17}, { 7,   106,-17}, { 7,    91, 18}, 
  { 7,    90,-18}, { 7,    75, 19}, { 7,    74,-19}, { 7,    59, 20}, 
  { 7,    58,-20}, { 7,    43, 21}, { 7,    42,-21}, { 7,    27, 22}, 
  { 7,    26,-22}, { 7,    11, 23}, { 7,    10,-23}, { 7,     8, 24}, 
  { 8,   243,-24}, { 8,   240, 25}, { 8,   211,-25}, { 8,   208, 26}, 
  { 8,   179,-26}, { 8,   176, 27}, { 8,   147,-27}, { 8,   144, 28}, 
  { 8,   115,-28}, { 8,   112, 29}, { 8,    83,-29}, { 8,    80, 30}, 
  { 8,    51,-30}, { 8,    48, 31}, { 8,    19,-31}, { 9,   484, 32}, 
  { 9,   483,-32}, { 9,   421, 33}, { 9,   420,-33}, { 9,   357, 34}, 
  { 9,   356,-34}, { 9,   293, 35}, { 9,   292,-35}, { 9,   229, 36}, 
  { 9,   228,-36}, { 9,   226, 37}, { 9,   165,-37}, { 9,   162, 38}, 
  { 9,   101,-38}, { 9,    98, 39}, { 9,    37,-39}, {10,   970, 40}, 
  {10,   965,-40}, {10,   839, 41}, {10,   838,-41}, {10,   711, 42}, 
  {10,   710,-42}, {10,   708, 43}, {10,   583,-43}, {10,   580, 44}, 
  {10,   455,-44}, {10,   329, 45}, {10,   328,-45}, {10,   201, 46}, 
  {10,   200,-46}, {10,   198, 47}, {10,    73,-47}, {11,  1942, 48}, 
  {11,  1929,-48}, {11,  1675, 49}, {11,  1674,-49}, {11,  1672, 50}, 
  {11,  1419,-50}, {11,  1165, 51}, {11,  1164,-51}, {11,  1162, 52}, 
  {11,   909,-52}, {11,   655, 53}, {11,   654,-53}, {11,   652, 54}, 
  {11,   399,-54}, {11,   145, 55}, {11,   144,-55}, {12,  3886, 56}, 
  {12,  3857,-56}, {12,  3347, 57}, {12,  3346,-57}, {12,  2837, 58}, 
  {12,  2836,-58}, {12,  2327, 59}, {12,  2326,-59}, {12,  1817, 60}, 
  {12,  1816,-60}, {12,  1307, 61}, {12,  1306,-61}, {12,   797, 62}, 
  {12,   796,-62}, {13,  7775, 63}, {13,  7774,-63}, {13,  7713, 64}, 
  {13,  7712,-64}, { 0,     0,  0}
};

huff_entry_t *bitalloc_select[11][8] =
{
  { 0 },
  { bitalloc_a_3, 0 },
  { bitalloc_a_5, bitalloc_b_5, bitalloc_c_5, 0 },
  { bitalloc_a_7, bitalloc_b_7, bitalloc_c_7, 0 },
  { bitalloc_a_9, bitalloc_b_9, bitalloc_c_9, 0 },
  { bitalloc_a_13, bitalloc_b_13, bitalloc_c_13, 0 },
  { bitalloc_a_17, bitalloc_b_17, bitalloc_c_17, bitalloc_d_17,
    bitalloc_e_17, bitalloc_f_17, bitalloc_g_17, 0 },
  { bitalloc_a_25, bitalloc_b_25, bitalloc_c_25, bitalloc_d_25,
    bitalloc_e_25, bitalloc_f_25, bitalloc_g_25, 0 },
  { bitalloc_a_33, bitalloc_b_33, bitalloc_c_33, bitalloc_d_33,
    bitalloc_e_33, bitalloc_f_33, bitalloc_g_33, 0 },
  { bitalloc_a_65, bitalloc_b_65, bitalloc_c_65, bitalloc_d_65,
    bitalloc_e_65, bitalloc_f_65, bitalloc_g_65, 0 },
  { bitalloc_a_129, bitalloc_b_129, bitalloc_c_129, bitalloc_d_129,
    bitalloc_e_129, bitalloc_f_129, bitalloc_g_129, 0 },
};

static int InverseQ( dca_state_t * state, huff_entry_t * huff )
{
    int value = 0;
    int length = 0, j;

    while( 1 )
    {
        length++;
        value <<= 1;
        value |= bitstream_get (state, 1);

	for( j = 0; huff[j].length != 0 && huff[j].length < length; j++ );

	if( huff[j].length == 0 ) break;

	for( ; huff[j].length == length; j++ )
	{
	    if( huff[j].code == value ) return huff[j].value;
	}
    }

    return 0;
}
