#!/usr/bin/perl -w 

%consonants = (
	"k" => "0x0b15",
	"kh" => "0x0b16",
	"g" => "0x0b17",
	"gh" => "0x0b18",
	"N^" => "0x0b19",
	"~N" => "0x0b19",
	"c" => "0x0b1a",
	"ch" => "0x0b1a",
	"chh" => "0x0b1b",
	"Ch" => "0x0b1b",
	"j" => "0x0b1c",
	"jh" => "0x0b1d",
	"~n" => "0x0b1e",
	"JN" => "0x0b1e",
	"T" => "0x0b1f",
	"Th" => "0x0b20",
	"D" => "0x0b21",
	"Dh" => "0x0b22",
	"N" => "0x0b23",
	"t" => "0x0b24",
	"th" => "0x0b25",
	"d" => "0x0b26",
	"dh" => "0x0b27",
	"n" => "0x0b28",
	"p" => "0x0b2a",
	"ph" => "0x0b2b",
	"b" => "0x0b2c",
	"bh" => "0x0b2d",
	"m" => "0x0b2e",
	"y" => "0x0b2f",
	"r" => "0x0b30",
	"l" => "0x0b32",
	"L" => "0x0b33",
	"ld" => "0x0b33",
	"sh" => "0x0b36",
	"shh" => "0x0b37",
	"Sh" => "0x0b37",
	"s" => "0x0b38",
	"h" => "0x0b39",
	".D" => "0x0b5c",
	".Dh" => "0x0b5d",
	"Y" => "0x0b5f",
	"x" => "0x0b15 0x0b4d 0x0b37",
	"GY" => "0x0b1c 0x0b4d 0x0b1e",
	"dny" => "0x0b1c 0x0b4d 0x0b1e",
);

%vowels = (
	"" => " 0x0b4d",
	"a" => "",
	"A" => " 0x0b3e",
	"aa" => " 0x0b3e",
	"i" => " 0x0b3f",
	"I" => " 0x0b40",
	"ii" => " 0x0b40",
	"u" => " 0x0b41",
	"U" => " 0x0b42",
	"uu" => " 0x0b42",
	"R^i" => " 0x0b43",
	"RRi" => " 0x0b43",
	"e" => " 0x0b47",
	"ai" => " 0x0b48",
	"o" => " 0x0b4b",
	"au" => " 0x0b4c",
	".h" => " 0x0b4d 0x200c",
);

print "// Oriya kmap according to Itrans transliteration\n";
print "// by Miikka-Markus Alhonen 2002-01-26\n\n";
print "// Consonant + vowel/virama\n";

foreach $cons (sort keys %consonants) {
  foreach $vowel (sort keys %vowels) {
    printf ("\"%s%s=%s%s\",\n",$cons,$vowel,$consonants{$cons},$vowels{$vowel});
  }
}

print <<EOF;

// Independent vowels

"a=0x0b05",
"A=0x0b06",
"aa=0x0b06",
"i=0x0b07",
"I=0x0b08",
"ii=0x0b08",
"u=0x0b09",
"U=0x0b0a",
"uu=0x0b0a",
"R^i=0x0b0b",
"RRi=0x0b0b",
"L^i=0x0b0c",
"LLi=0x0b0c",
"e=0x0b0f",
"ai=0x0b10",
"o=0x0b13",
"au=0x0b14",
"R^I=0x0b60",
"RRI=0x0b60",
"L^I=0x0b61",
"LLI=0x0b61",

// Numbers

"0x30=0x0b66",
"0x31=0x0b67",
"0x32=0x0b68",
"0x33=0x0b69",
"0x34=0x0b6a",
"0x35=0x0b6b",
"0x36=0x0b6c",
"0x37=0x0b6d",
"0x38=0x0b6e",
"0x39=0x0b6f",

// Other marks

".N=0x0b01",
".n=0x0b02",
"M=0x0b02",
"H=0x0b03",
".a=0x0b3d",
".h=0x0b4d 0x200c",
".=0x0964",
"..=0x0965",
"|=0x0964",
"||=0x0965",
";=0x0965",
"{\\\\rm 0x20 .}=0x002e",
"{}=0x200d",
EOF
