#!/usr/bin/python3 -su

# Copyright (C) 2025 - 2025 ENCRYPTED SUPPORT LLC <adrelanos@whonix.org>
# See the file COPYING for copying conditions.

# pylint: disable=invalid-name

"""
packagecard.py - Card widget that displays an application package.
"""

from PyQt5.QtCore import pyqtSignal
from PyQt5.QtGui import QPixmap
from PyQt5.QtWidgets import QWidget

## NOTE: _ui modules are autogenerated by build-ui.sh.
from browser_choice.packagecard_ui import Ui_PackageCard


# pylint: disable=too-many-instance-attributes
class PackageCard(QWidget):
    """
    Displays information about a package, and provides a radio button for
    selecting that package.
    """

    toggled = pyqtSignal(bool)

    # pylint: disable=too-many-arguments
    def __init__(
        self,
        repo_id: str,
        package_short_description: str,
        package_long_description: str,
        package_icon: QPixmap,
        supports_install: bool,
        supports_update: bool,
        supports_remove: bool,
        supports_purge: bool,
        is_installed: bool,
        capability_info: str,
        mod_requires_privileges: bool,
        parent: QWidget | None = None,
    ):
        super().__init__(parent)
        self.ui = Ui_PackageCard()
        self.ui.setupUi(self)

        self.repo_id: str = repo_id
        self.ui.packageRadioButton.setText(package_short_description)
        self.ui.packageRadioButton.toggled.connect(self.toggled)
        self.ui.packageIconLabel.setText("")
        self.ui.packageIconLabel.setPixmap(package_icon)
        self.supports_install: bool = supports_install
        self.supports_update: bool = supports_update
        self.supports_remove: bool = supports_remove
        self.supports_purge: bool = supports_purge
        self.is_installed: bool = is_installed
        self.mod_requires_privileges: bool = mod_requires_privileges

        if capability_info == "":
            if is_installed:
                self.ui.packageInfoLabel.setText(
                    f"{package_long_description} (Installed)"
                )
            else:
                self.ui.packageInfoLabel.setText(package_long_description)
        else:
            ## Package is not compatible with the system for some reason,
            ## disable selecting it and gray it out.
            self.ui.packageIconLabel.setEnabled(False)
            self.ui.packageRadioButton.setEnabled(False)
            self.ui.packageInfoLabel.setEnabled(False)
            self.ui.packageInfoLabel.setText(
                f"{package_long_description} ({capability_info})"
            )

    def isChecked(self) -> bool:
        """
        Returns True if this card is selected.
        """

        return self.ui.packageRadioButton.isChecked()
